﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private startTime As TimeSpan


    Public Sub New()
        InitializeComponent()
        AddHandler CompositionTarget.Rendering, AddressOf OnCompositionTargetRendering
    End Sub


    Private Sub OnCompositionTargetRendering(ByVal sender As Object, ByVal args As EventArgs)
        Dim renderingTime = (TryCast(args, RenderingEventArgs)).RenderingTime

        If startTime.Ticks = 0 Then
            startTime = renderingTime
        Else
            Dim elapsedTime = renderingTime.Subtract(startTime)
            rotate.Angle = 180 * elapsedTime.TotalSeconds Mod 360
        End If
    End Sub
End Class
